/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil.cache;

import com.google.protobuf.Descriptors;
import com.gotocompany.stencil.DescriptorMapBuilder;
import com.gotocompany.stencil.exception.StencilRuntimeException;
import com.gotocompany.stencil.http.RemoteFile;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public interface SchemaRefreshStrategy {
    public Map<String, Descriptors.Descriptor> refresh(String var1, RemoteFile var2, Map<String, Descriptors.Descriptor> var3);

    public static SchemaRefreshStrategy longPollingStrategy() {
        return (url, remoteFile, prevDescriptor) -> DescriptorMapBuilder.buildFrom(url, remoteFile);
    }

    public static SchemaRefreshStrategy versionBasedRefresh() {
        AtomicInteger lastVersion = new AtomicInteger();
        return (url, remoteFile, prevDescriptor) -> {
            try {
                byte[] data = remoteFile.fetch(String.format("%s/versions", url));
                JSONObject json = new JSONObject(new String(data));
                JSONArray versions = json.getJSONArray("versions");
                Integer maxVersion = 0;
                for (int i = 0; i < versions.length(); ++i) {
                    if (versions.getInt(i) <= maxVersion) continue;
                    maxVersion = versions.getInt(i);
                }
                if (maxVersion != 0 && maxVersion.intValue() != lastVersion.get()) {
                    String newURL = String.format("%s/versions/%d", url, maxVersion);
                    Map<String, Descriptors.Descriptor> newSchema = DescriptorMapBuilder.buildFrom(newURL, remoteFile);
                    lastVersion.set(maxVersion);
                    return newSchema;
                }
                return prevDescriptor;
            }
            catch (IOException e) {
                throw new StencilRuntimeException(e);
            }
        };
    }
}

