/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil.client;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.protobuf.Descriptors;
import com.gotocompany.stencil.cache.SchemaCacheLoader;
import com.gotocompany.stencil.client.StencilClient;
import com.gotocompany.stencil.config.StencilConfig;
import com.gotocompany.stencil.exception.StencilRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLStencilClient
implements Serializable,
StencilClient {
    private String url;
    private SchemaCacheLoader cacheLoader;
    private LoadingCache<String, Map<String, Descriptors.Descriptor>> descriptorCache;
    private long ttlMs;
    private final Logger logger = LoggerFactory.getLogger(URLStencilClient.class);

    public URLStencilClient(String url, StencilConfig config, SchemaCacheLoader cacheLoader) {
        this(url, config, cacheLoader, Ticker.systemTicker());
    }

    public URLStencilClient(String url, StencilConfig stencilConfig, SchemaCacheLoader cacheLoader, Ticker ticker) {
        this.ttlMs = stencilConfig.getCacheTtlMs();
        this.url = url;
        this.cacheLoader = cacheLoader;
        this.descriptorCache = CacheBuilder.newBuilder().ticker(ticker).refreshAfterWrite(this.ttlMs, TimeUnit.MILLISECONDS).build((CacheLoader)cacheLoader);
        this.logger.info("configuring URL Stencil client with TTL: {} milliseconds, auto refresh: {}", (Object)this.ttlMs, (Object)stencilConfig.getCacheAutoRefresh());
    }

    @Override
    public Descriptors.Descriptor get(String className) {
        try {
            return (Descriptors.Descriptor)((Map)this.descriptorCache.get((Object)this.url)).get(className);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new StencilRuntimeException(e);
        }
    }

    @Override
    public Map<String, Descriptors.Descriptor> getAll() {
        try {
            HashMap<String, Descriptors.Descriptor> descriptorMap = new HashMap<String, Descriptors.Descriptor>();
            ((Map)this.descriptorCache.get((Object)this.url)).entrySet().stream().forEach(mapEntry -> {
                Descriptors.Descriptor desc = (Descriptors.Descriptor)mapEntry.getValue();
                if (desc != null) {
                    descriptorMap.put((String)mapEntry.getKey(), desc);
                }
            });
            return descriptorMap;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new StencilRuntimeException(e);
        }
    }

    @Override
    public void refresh() {
        this.descriptorCache.refresh((Object)this.url);
    }

    public long getTTLMs() {
        return this.ttlMs;
    }

    @Override
    public void close() throws IOException {
        this.cacheLoader.close();
    }
}

