/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil.http;

import com.gotocompany.stencil.http.RemoteFile;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class RemoteFileImpl
implements RemoteFile,
ResponseHandler<byte[]> {
    private CloseableHttpClient closeableHttpClient;

    public RemoteFileImpl(CloseableHttpClient httpClient) {
        this.closeableHttpClient = httpClient;
    }

    @Override
    public byte[] fetch(String url) throws IOException {
        HttpGet httpget = new HttpGet(url);
        byte[] responseBody = (byte[])this.closeableHttpClient.execute((HttpUriRequest)httpget, (ResponseHandler)this);
        return responseBody;
    }

    @Override
    public void close() throws IOException {
        this.closeableHttpClient.close();
    }

    public byte[] handleResponse(HttpResponse response) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && status < 300) {
            HttpEntity entity = response.getEntity();
            return entity != null ? EntityUtils.toByteArray((HttpEntity)entity) : null;
        }
        throw new ClientProtocolException("Unexpected response status: " + status);
    }
}

