/*
 * Decompiled with CFR 0.152.
 */
package com.gotocompany.stencil.http;

import com.gotocompany.stencil.config.StencilConfig;
import com.gotocompany.stencil.http.RemoteFileImpl;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(RemoteFileImpl.class);

    public static CloseableHttpClient create(StencilConfig stencilConfig) {
        int timeout = stencilConfig.getFetchTimeoutMs();
        final long backoffMs = stencilConfig.getFetchBackoffMinMs();
        final int retries = stencilConfig.getFetchRetries();
        logger.info("initialising HTTP client with timeout: {}ms, backoff: {}ms, max retry attempts: {}", new Object[]{timeout, backoffMs, retries});
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setDefaultHeaders(stencilConfig.getFetchHeaders()).setConnectionManagerShared(true).setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){
            long waitPeriod;
            {
                this.waitPeriod = backoffMs;
            }

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                if (executionCount <= retries && response.getStatusLine().getStatusCode() >= 400) {
                    logger.info("Retrying requests, attempts left: {}", (Object)(retries - executionCount));
                    this.waitPeriod *= 2L;
                    return true;
                }
                return false;
            }

            public long getRetryInterval() {
                return this.waitPeriod;
            }
        }).build();
    }
}

