package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis.
 *
 *  @param     groups  groups is a list of APIGroup.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
*/
case class APIGroupList(
  groups: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup],
  apiVersion: Option[String] = None,
  kind: Option[String] = None
)

object APIGroupList {
  implicit lazy val encoder: Encoder.AsObject[APIGroupList] = deriveEncoder
  implicit lazy val decoder: Decoder[APIGroupList] = deriveDecoder
}
