package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Affinity is a group of affinity scheduling rules.
 *
 *  @param    nodeAffinity  Describes node affinity scheduling rules for the pod.
 *  @param     podAffinity  Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as
 *                          some other pod(s)).
 *  @param podAntiAffinity  Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone,
 *                          etc. as some other pod(s)).
*/
case class Affinity(
  nodeAffinity: Option[io.k8s.api.core.v1.NodeAffinity] = None,
  podAffinity: Option[io.k8s.api.core.v1.PodAffinity] = None,
  podAntiAffinity: Option[io.k8s.api.core.v1.PodAntiAffinity] = None
)

object Affinity {
  implicit lazy val encoder: Encoder.AsObject[Affinity] = deriveEncoder
  implicit lazy val decoder: Decoder[Affinity] = deriveDecoder
}
