package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 *  @param      secretName  secretName is the name of secret that contains Azure Storage Account Name and Key
 *  @param       shareName  shareName is the azure Share Name
 *  @param        readOnly  readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts
 *  @param secretNamespace  secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key
 *                          default is the same as the Pod
*/
case class AzureFilePersistentVolumeSource(
  secretName: String,
  shareName: String,
  readOnly: Option[Boolean] = None,
  secretNamespace: Option[String] = None
)

object AzureFilePersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[AzureFilePersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[AzureFilePersistentVolumeSource] = deriveDecoder
}
