package io.k8s.api.rbac.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject.
 *
 *  @param    roleRef  RoleRef can only reference a ClusterRole in the global namespace. If the RoleRef cannot be resolved,
 *                     the Authorizer must return an error.
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata.
 *  @param   subjects  Subjects holds references to the objects the role applies to.
*/
case class ClusterRoleBinding(
  roleRef: io.k8s.api.rbac.v1.RoleRef,
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  subjects: Option[Seq[io.k8s.api.rbac.v1.Subject]] = None
)

object ClusterRoleBinding {
  implicit lazy val encoder: Encoder.AsObject[ClusterRoleBinding] = deriveEncoder
  implicit lazy val decoder: Decoder[ClusterRoleBinding] = deriveDecoder
}
