package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Information about the condition of a component.
 *
 *  @param  `type`  Type of condition for a component. Valid value: "Healthy"
 *  @param  status  Status of the condition for a component. Valid values for "Healthy": "True", "False", or "Unknown".
 *  @param   error  Condition error code for a component. For example, a health check error code.
 *  @param message  Message about the condition for a component. For example, information about a health check.
*/
case class ComponentCondition(
  `type`: String,
  status: String,
  error: Option[String] = None,
  message: Option[String] = None
)

object ComponentCondition {
  implicit lazy val encoder: Encoder.AsObject[ComponentCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[ComponentCondition] = deriveDecoder
}
