package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
 *
 *  @param        namespace  Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all
 *                           cases.
 *  @param             name  Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.
 *  @param kubeletConfigKey  KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration
 *                           structure This field is required in all cases.
 *  @param  resourceVersion  ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden
 *                           in Node.Spec, and required in Node.Status.
 *  @param              uid  UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and
 *                           required in Node.Status.
*/
case class ConfigMapNodeConfigSource(
  namespace: String,
  name: String,
  kubeletConfigKey: String,
  resourceVersion: Option[String] = None,
  uid: Option[String] = None
)

object ConfigMapNodeConfigSource {
  implicit lazy val encoder: Encoder.AsObject[ConfigMapNodeConfigSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ConfigMapNodeConfigSource] = deriveDecoder
}
