package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Describe a container image
 *
 *  @param     names  Names by which this image is known. e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
 *  @param sizeBytes  The size of the image in bytes.
*/
case class ContainerImage(
  names: Option[Seq[String]] = None,
  sizeBytes: Option[Long] = None
)

object ContainerImage {
  implicit lazy val encoder: Encoder.AsObject[ContainerImage] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerImage] = deriveDecoder
}
