package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ContainerStateRunning is a running state of a container.
 *
 *  @param startedAt  Time at which the container was last (re-)started
*/
case class ContainerStateRunning(
  startedAt: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
)

object ContainerStateRunning {
  implicit lazy val encoder: Encoder.AsObject[ContainerStateRunning] = deriveEncoder
  implicit lazy val decoder: Decoder[ContainerStateRunning] = deriveDecoder
}
