package io.k8s.apiextensionsapiserver.pkg.apis.apiextensions.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** CustomResourceColumnDefinition specifies a column for server side printing.
 *
 *  @param        name  name is a human readable name for the column.
 *  @param      `type`  type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types
 *                      for details.
 *  @param    jsonPath  jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource
 *                      to produce the value for this column.
 *  @param description  description is a human readable description of this column.
 *  @param      format  format is an optional OpenAPI type definition for this column. The 'name' format is applied to the
 *                      primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types
 *                      for details.
 *  @param    priority  priority is an integer defining the relative importance of this column compared to others. Lower numbers
 *                      are considered higher priority. Columns that may be omitted in limited space scenarios should be given
 *                      a priority greater than 0.
*/
case class CustomResourceColumnDefinition(
  name: String,
  `type`: String,
  jsonPath: String,
  description: Option[String] = None,
  format: Option[String] = None,
  priority: Option[Int] = None
)

object CustomResourceColumnDefinition {
  implicit lazy val encoder: Encoder.AsObject[CustomResourceColumnDefinition] = deriveEncoder
  implicit lazy val decoder: Decoder[CustomResourceColumnDefinition] = deriveDecoder
}
