package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** DeploymentCondition describes the state of a deployment at a certain point.
 *
 *  @param             `type`  Type of deployment condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param lastTransitionTime  Last time the condition transitioned from one status to another.
 *  @param     lastUpdateTime  The last time this condition was updated.
 *  @param            message  A human readable message indicating details about the transition.
 *  @param             reason  The reason for the condition's last transition.
*/
case class DeploymentCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastUpdateTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object DeploymentCondition {
  implicit lazy val encoder: Encoder.AsObject[DeploymentCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[DeploymentCondition] = deriveDecoder
}
