package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.
 *
 *  @param items  Items is a list of DownwardAPIVolume file
*/
case class DownwardAPIProjection(
  items: Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
)

object DownwardAPIProjection {
  implicit lazy val encoder: Encoder.AsObject[DownwardAPIProjection] = deriveEncoder
  implicit lazy val decoder: Decoder[DownwardAPIProjection] = deriveDecoder
}
