package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EndpointPort is a tuple that describes a single port.
 *
 *  @param        port  The port number of the endpoint.
 *  @param appProtocol  The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed
 *                      names are reserved for IANA standard service names (as per RFC-6335 and https://www.iana.org/assignments/service-names).
 *                      Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.
 *  @param        name  The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be
 *                      a DNS_LABEL. Optional only if one port is defined.
 *  @param    protocol  The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
*/
case class EndpointPort(
  port: Int,
  appProtocol: Option[String] = None,
  name: Option[String] = None,
  protocol: Option[String] = None
)

object EndpointPort {
  implicit lazy val encoder: Encoder.AsObject[EndpointPort] = deriveEncoder
  implicit lazy val decoder: Decoder[EndpointPort] = deriveDecoder
}
