package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EnvFromSource represents the source of a set of ConfigMaps
 *
 *  @param configMapRef  The ConfigMap to select from
 *  @param       prefix  An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
 *  @param    secretRef  The Secret to select from
*/
case class EnvFromSource(
  configMapRef: Option[io.k8s.api.core.v1.ConfigMapEnvSource] = None,
  prefix: Option[String] = None,
  secretRef: Option[io.k8s.api.core.v1.SecretEnvSource] = None
)

object EnvFromSource {
  implicit lazy val encoder: Encoder.AsObject[EnvFromSource] = deriveEncoder
  implicit lazy val decoder: Decoder[EnvFromSource] = deriveDecoder
}
