package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.
 *
 *  @param            count  Number of occurrences in this series up to the last heartbeat time
 *  @param lastObservedTime  Time of the last occurrence observed
*/
case class EventSeries(
  count: Option[Int] = None,
  lastObservedTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime] = None
)

object EventSeries {
  implicit lazy val encoder: Encoder.AsObject[EventSeries] = deriveEncoder
  implicit lazy val decoder: Decoder[EventSeries] = deriveDecoder
}
