package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ExecAction describes a "run in container" action.
 *
 *  @param command  Command is the command line to execute inside the container, the working directory for the command  is
 *                  root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so
 *                  traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to
 *                  that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
*/
case class ExecAction(
  command: Option[Seq[String]] = None
)

object ExecAction {
  implicit lazy val encoder: Encoder.AsObject[ExecAction] = deriveEncoder
  implicit lazy val decoder: Decoder[ExecAction] = deriveDecoder
}
