package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** 
 *
 *  @param    port  Port number of the gRPC service. Number must be in the range 1 to 65535.
 *  @param service  Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
 *                  If this is not specified, the default behavior is defined by gRPC.
*/
case class GRPCAction(
  port: Int,
  service: Option[String] = None
)

object GRPCAction {
  implicit lazy val encoder: Encoder.AsObject[GRPCAction] = deriveEncoder
  implicit lazy val decoder: Decoder[GRPCAction] = deriveDecoder
}
