package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.
 *
 *  @param          endpoints  endpoints is the endpoint name that details Glusterfs topology. More info:
 *                             https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
 *  @param               path  path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
 *  @param endpointsNamespace  endpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty,
 *                             the EndpointNamespace defaults to the same namespace as the bound PVC. More info:
 *                             https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
 *  @param           readOnly  readOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults
 *                             to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
*/
case class GlusterfsPersistentVolumeSource(
  endpoints: String,
  path: String,
  endpointsNamespace: Option[String] = None,
  readOnly: Option[Boolean] = None
)

object GlusterfsPersistentVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[GlusterfsPersistentVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[GlusterfsPersistentVolumeSource] = deriveDecoder
}
