package io.k8s.apimachinery.pkg.apis.meta.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** GroupVersion contains the "group/version" and "version" string of a version. It is made a struct to keep extensibility.
 *
 *  @param groupVersion  groupVersion specifies the API group and version in the form "group/version"
 *  @param      version  version specifies the version in the form of "version". This is to save the clients the trouble of
 *                       splitting the GroupVersion.
*/
case class GroupVersionForDiscovery(
  groupVersion: String,
  version: String
)

object GroupVersionForDiscovery {
  implicit lazy val encoder: Encoder.AsObject[GroupVersionForDiscovery] = deriveEncoder
  implicit lazy val decoder: Decoder[GroupVersionForDiscovery] = deriveDecoder
}
