package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** HTTPGetAction describes an action based on HTTP Get requests.
 *
 *  @param        port  Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name
 *                      must be an IANA_SVC_NAME.
 *  @param        host  Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead
 *  @param httpHeaders  Custom headers to set in the request. HTTP allows repeated headers.
 *  @param        path  Path to access on the HTTP server.
 *  @param      scheme  Scheme to use for connecting to the host. Defaults to HTTP.
*/
case class HTTPGetAction(
  port: com.goyeau.kubernetes.client.IntOrString,
  host: Option[String] = None,
  httpHeaders: Option[Seq[io.k8s.api.core.v1.HTTPHeader]] = None,
  path: Option[String] = None,
  scheme: Option[String] = None
)

object HTTPGetAction {
  implicit lazy val encoder: Encoder.AsObject[HTTPGetAction] = deriveEncoder
  implicit lazy val decoder: Decoder[HTTPGetAction] = deriveDecoder
}
