package io.k8s.api.autoscaling.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** current status of a horizontal pod autoscaler
 *
 *  @param                 currentReplicas  current number of replicas of pods managed by this autoscaler.
 *  @param                 desiredReplicas  desired number of replicas of pods managed by this autoscaler.
 *  @param currentCPUUtilizationPercentage  current average CPU utilization over all pods, represented as a percentage of requested
 *                                          CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.
 *  @param                   lastScaleTime  last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler
 *                                          to control how often the number of pods is changed.
 *  @param              observedGeneration  most recent generation observed by this autoscaler.
*/
case class HorizontalPodAutoscalerStatus(
  currentReplicas: Int,
  desiredReplicas: Int,
  currentCPUUtilizationPercentage: Option[Int] = None,
  lastScaleTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  observedGeneration: Option[Long] = None
)

object HorizontalPodAutoscalerStatus {
  implicit lazy val encoder: Encoder.AsObject[HorizontalPodAutoscalerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[HorizontalPodAutoscalerStatus] = deriveDecoder
}
