package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.
 *
 *  @param   path  path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More
 *                 info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
 *  @param `type`  type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
*/
case class HostPathVolumeSource(
  path: String,
  `type`: Option[String] = None
)

object HostPathVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[HostPathVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[HostPathVolumeSource] = deriveDecoder
}
