package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** JobCondition describes current state of a job.
 *
 *  @param             `type`  Type of job condition, Complete or Failed.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param      lastProbeTime  Last time the condition was checked.
 *  @param lastTransitionTime  Last time the condition transit from one status to another.
 *  @param            message  Human readable message indicating details about last transition.
 *  @param             reason  (brief) reason for the condition's last transition.
*/
case class JobCondition(
  `type`: String,
  status: String,
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object JobCondition {
  implicit lazy val encoder: Encoder.AsObject[JobCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[JobCondition] = deriveDecoder
}
