package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LimitRangeSpec defines a min/max usage limit for resources that match on kind.
 *
 *  @param limits  Limits is the list of LimitRangeItem objects that are enforced.
*/
case class LimitRangeSpec(
  limits: Seq[io.k8s.api.core.v1.LimitRangeItem]
)

object LimitRangeSpec {
  implicit lazy val encoder: Encoder.AsObject[LimitRangeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[LimitRangeSpec] = deriveDecoder
}
