package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.
 *
 *  @param hostname  Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
 *  @param       ip  IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack
 *                   load-balancers)
 *  @param    ports  Ports is a list of records of service ports If used, every port defined in the service should have an
 *                   entry in it
*/
case class LoadBalancerIngress(
  hostname: Option[String] = None,
  ip: Option[String] = None,
  ports: Option[Seq[io.k8s.api.core.v1.PortStatus]] = None
)

object LoadBalancerIngress {
  implicit lazy val encoder: Encoder.AsObject[LoadBalancerIngress] = deriveEncoder
  implicit lazy val decoder: Decoder[LoadBalancerIngress] = deriveDecoder
}
