package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** LoadBalancerStatus represents the status of a load-balancer.
 *
 *  @param ingress  Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should
 *                  be sent to these ingress points.
*/
case class LoadBalancerStatus(
  ingress: Option[Seq[io.k8s.api.core.v1.LoadBalancerIngress]] = None
)

object LoadBalancerStatus {
  implicit lazy val encoder: Encoder.AsObject[LoadBalancerStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[LoadBalancerStatus] = deriveDecoder
}
