package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NamespaceCondition contains details about state of namespace.
 *
 *  @param             `type`  Type of namespace controller condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param lastTransitionTime
 *  @param            message
 *  @param             reason
*/
case class NamespaceCondition(
  `type`: String,
  status: String,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object NamespaceCondition {
  implicit lazy val encoder: Encoder.AsObject[NamespaceCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[NamespaceCondition] = deriveDecoder
}
