package io.k8s.api.networking.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NetworkPolicySpec provides the specification of a NetworkPolicy
 *
 *  @param podSelector  Selects the pods to which this NetworkPolicy object applies. The array of ingress rules is applied
 *                      to any pods selected by this field. Multiple network policies can select the same set of pods. In this
 *                      case, the ingress rules for each are combined additively. This field is NOT optional and follows standard
 *                      label selector semantics. An empty podSelector matches all pods in this namespace.
 *  @param      egress  List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no
 *                      NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic
 *                      matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the
 *                      pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to
 *                      ensure that the pods it selects are isolated by default). This field is beta-level in 1.8
 *  @param     ingress  List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are
 *                      no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic
 *                      source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the
 *                      NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy
 *                      does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by
 *                      default)
 *  @param policyTypes  List of rule types that the NetworkPolicy relates to. Valid options are ["Ingress"], ["Egress"], or
 *                      ["Ingress", "Egress"]. If this field is not specified, it will default based on the existence of Ingress
 *                      or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies
 *                      (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write
 *                      an egress-only policy, you must explicitly specify policyTypes [ "Egress" ]. Likewise, if you want to
 *                      write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include
 *                      "Egress" (since such a policy would not include an Egress section and would otherwise default to just
 *                      [ "Ingress" ]). This field is beta-level in 1.8
*/
case class NetworkPolicySpec(
  podSelector: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  egress: Option[Seq[io.k8s.api.networking.v1.NetworkPolicyEgressRule]] = None,
  ingress: Option[Seq[io.k8s.api.networking.v1.NetworkPolicyIngressRule]] = None,
  policyTypes: Option[Seq[String]] = None
)

object NetworkPolicySpec {
  implicit lazy val encoder: Encoder.AsObject[NetworkPolicySpec] = deriveEncoder
  implicit lazy val decoder: Decoder[NetworkPolicySpec] = deriveDecoder
}
