package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeAddress contains information for the node's address.
 *
 *  @param  `type`  Node address type, one of Hostname, ExternalIP or InternalIP.
 *  @param address  The node address.
*/
case class NodeAddress(
  `type`: String,
  address: String
)

object NodeAddress {
  implicit lazy val encoder: Encoder.AsObject[NodeAddress] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeAddress] = deriveDecoder
}
