package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeCondition contains condition information for a node.
 *
 *  @param             `type`  Type of node condition.
 *  @param             status  Status of the condition, one of True, False, Unknown.
 *  @param  lastHeartbeatTime  Last time we got an update on a given condition.
 *  @param lastTransitionTime  Last time the condition transit from one status to another.
 *  @param            message  Human readable message indicating details about last transition.
 *  @param             reason  (brief) reason for the condition's last transition.
*/
case class NodeCondition(
  `type`: String,
  status: String,
  lastHeartbeatTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object NodeCondition {
  implicit lazy val encoder: Encoder.AsObject[NodeCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeCondition] = deriveDecoder
}
