package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeDaemonEndpoints lists ports opened by daemons running on the Node.
 *
 *  @param kubeletEndpoint  Endpoint on which Kubelet is listening.
*/
case class NodeDaemonEndpoints(
  kubeletEndpoint: Option[io.k8s.api.core.v1.DaemonEndpoint] = None
)

object NodeDaemonEndpoints {
  implicit lazy val encoder: Encoder.AsObject[NodeDaemonEndpoints] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeDaemonEndpoints] = deriveDecoder
}
