package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** NodeStatus is information about the current status of a node.
 *
 *  @param       addresses  List of addresses reachable to the node. Queried from cloud provider, if available. More info:
 *                          https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable,
 *                          but the merge key is not sufficiently unique, which can cause data corruption when it is merged.
 *                          Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example.
 *  @param     allocatable  Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity
 *  @param        capacity  Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
 *  @param      conditions  Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
 *  @param          config  Status of the config assigned to the node via the dynamic Kubelet config feature.
 *  @param daemonEndpoints  Endpoints of daemons running on the Node.
 *  @param          images  List of container images on this node
 *  @param        nodeInfo  Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info
 *  @param           phase  NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase
 *                          The field is never populated, and now is deprecated.
 *  @param volumesAttached  List of volumes that are attached to the node.
 *  @param    volumesInUse  List of attachable volumes in use (mounted) by the node.
*/
case class NodeStatus(
  addresses: Option[Seq[io.k8s.api.core.v1.NodeAddress]] = None,
  allocatable: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  conditions: Option[Seq[io.k8s.api.core.v1.NodeCondition]] = None,
  config: Option[io.k8s.api.core.v1.NodeConfigStatus] = None,
  daemonEndpoints: Option[io.k8s.api.core.v1.NodeDaemonEndpoints] = None,
  images: Option[Seq[io.k8s.api.core.v1.ContainerImage]] = None,
  nodeInfo: Option[io.k8s.api.core.v1.NodeSystemInfo] = None,
  phase: Option[String] = None,
  volumesAttached: Option[Seq[io.k8s.api.core.v1.AttachedVolume]] = None,
  volumesInUse: Option[Seq[String]] = None
)

object NodeStatus {
  implicit lazy val encoder: Encoder.AsObject[NodeStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[NodeStatus] = deriveDecoder
}
