package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator.
 *                     More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
 *  @param     status  status represents the current information/status for the persistent volume. Populated by the system.
 *                     Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
*/
case class PersistentVolume(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  status: Option[io.k8s.api.core.v1.PersistentVolumeStatus] = None
)

object PersistentVolume {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolume] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolume] = deriveDecoder
}
