package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PersistentVolumeClaimStatus is the current status of a persistent volume claim.
 *
 *  @param        accessModes  accessModes contains the actual access modes the volume backing the PVC has. More info:
 *                             https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
 *  @param allocatedResources  allocatedResources is the storage resource within AllocatedResources tracks the capacity allocated
 *                             to a PVC. It may be larger than the actual capacity when a volume expansion operation is requested.
 *                             For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If
 *                             allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume
 *                             expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion
 *                             operations in progress and if the actual volume capacity is equal or lower than the requested
 *                             capacity. This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
 *  @param           capacity  capacity represents the actual resources of the underlying volume.
 *  @param         conditions  conditions is the current Condition of persistent volume claim. If underlying persistent volume
 *                             is being resized then the Condition will be set to 'ResizeStarted'.
 *  @param              phase  phase represents the current phase of PersistentVolumeClaim.
 *  @param       resizeStatus  resizeStatus stores status of resize operation. ResizeStatus is not set by default but when
 *                             expansion is complete resizeStatus is set to empty string by resize controller or kubelet. This
 *                             is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
*/
case class PersistentVolumeClaimStatus(
  accessModes: Option[Seq[String]] = None,
  allocatedResources: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  conditions: Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]] = None,
  phase: Option[String] = None,
  resizeStatus: Option[String] = None
)

object PersistentVolumeClaimStatus {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeClaimStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeClaimStatus] = deriveDecoder
}
