package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PersistentVolumeSpec is the specification of a persistent volume.
 *
 *  @param                   accessModes  accessModes contains all ways the volume can be mounted. More info:
 *                                        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
 *  @param          awsElasticBlockStore  awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's
 *                                        host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
 *  @param                     azureDisk  azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod
 *  @param                     azureFile  azureFile represents an Azure File Service mount on the host and bind mount to the
 *                                        pod.
 *  @param                      capacity  capacity is the description of the persistent volume's resources and capacity. More
 *                                        info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
 *  @param                        cephfs  cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
 *  @param                        cinder  cinder represents a cinder volume attached and mounted on kubelets host machine.
 *                                        More info: https://examples.k8s.io/mysql-cinder-pd/README.md
 *  @param                      claimRef  claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
 *                                        Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between
 *                                        PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
 *  @param                           csi  csi represents storage that is handled by an external CSI driver (Beta feature).
 *  @param                            fc  fc represents a Fibre Channel resource that is attached to a kubelet's host machine
 *                                        and then exposed to the pod.
 *  @param                    flexVolume  flexVolume represents a generic volume resource that is provisioned/attached using
 *                                        an exec based plugin.
 *  @param                       flocker  flocker represents a Flocker volume attached to a kubelet's host machine and exposed
 *                                        to the pod for its usage. This depends on the Flocker control service being running
 *  @param             gcePersistentDisk  gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet's
 *                                        host machine and then exposed to the pod. Provisioned by an admin. More info:
 *                                        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
 *  @param                     glusterfs  glusterfs represents a Glusterfs volume that is attached to a host and exposed to
 *                                        the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md
 *  @param                      hostPath  hostPath represents a directory on the host. Provisioned by a developer or tester.
 *                                        This is useful for single-node development and testing only! On-host storage is not
 *                                        supported in any way and WILL NOT WORK in a multi-node cluster. More info:
 *                                        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
 *  @param                         iscsi  iscsi represents an ISCSI Disk resource that is attached to a kubelet's host machine
 *                                        and then exposed to the pod. Provisioned by an admin.
 *  @param                         local  local represents directly-attached storage with node affinity
 *  @param                  mountOptions  mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount
 *                                        will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
 *  @param                           nfs  nfs represents an NFS mount on the host. Provisioned by an admin. More info:
 *                                        https://kubernetes.io/docs/concepts/storage/volumes#nfs
 *  @param                  nodeAffinity  nodeAffinity defines constraints that limit what nodes this volume can be accessed
 *                                        from. This field influences the scheduling of pods that use this volume.
 *  @param persistentVolumeReclaimPolicy  persistentVolumeReclaimPolicy defines what happens to a persistent volume when released
 *                                        from its claim. Valid options are Retain (default for manually created PersistentVolumes),
 *                                        Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated).
 *                                        Recycle must be supported by the volume plugin underlying this PersistentVolume. More
 *                                        info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
 *  @param          photonPersistentDisk  photonPersistentDisk represents a PhotonController persistent disk attached and mounted
 *                                        on kubelets host machine
 *  @param                portworxVolume  portworxVolume represents a portworx volume attached and mounted on kubelets host
 *                                        machine
 *  @param                       quobyte  quobyte represents a Quobyte mount on the host that shares a pod's lifetime
 *  @param                           rbd  rbd represents a Rados Block Device mount on the host that shares a pod's lifetime.
 *                                        More info: https://examples.k8s.io/volumes/rbd/README.md
 *  @param                       scaleIO  scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes
 *                                        nodes.
 *  @param              storageClassName  storageClassName is the name of StorageClass to which this persistent volume belongs.
 *                                        Empty value means that this volume does not belong to any StorageClass.
 *  @param                     storageos  storageOS represents a StorageOS volume that is attached to the kubelet's host machine
 *                                        and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md
 *  @param                    volumeMode  volumeMode defines if a volume is intended to be used with a formatted filesystem
 *                                        or to remain in raw block state. Value of Filesystem is implied when not included
 *                                        in spec.
 *  @param                 vsphereVolume  vsphereVolume represents a vSphere volume attached and mounted on kubelets host
 *                                        machine
*/
case class PersistentVolumeSpec(
  accessModes: Option[Seq[String]] = None,
  awsElasticBlockStore: Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  azureDisk: Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile: Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] = None,
  capacity: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  cephfs: Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource] = None,
  cinder: Option[io.k8s.api.core.v1.CinderPersistentVolumeSource] = None,
  claimRef: Option[io.k8s.api.core.v1.ObjectReference] = None,
  csi: Option[io.k8s.api.core.v1.CSIPersistentVolumeSource] = None,
  fc: Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  flexVolume: Option[io.k8s.api.core.v1.FlexPersistentVolumeSource] = None,
  flocker: Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  gcePersistentDisk: Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  glusterfs: Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] = None,
  hostPath: Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  iscsi: Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] = None,
  local: Option[io.k8s.api.core.v1.LocalVolumeSource] = None,
  mountOptions: Option[Seq[String]] = None,
  nfs: Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  nodeAffinity: Option[io.k8s.api.core.v1.VolumeNodeAffinity] = None,
  persistentVolumeReclaimPolicy: Option[String] = None,
  photonPersistentDisk: Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  portworxVolume: Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  quobyte: Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  rbd: Option[io.k8s.api.core.v1.RBDPersistentVolumeSource] = None,
  scaleIO: Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] = None,
  storageClassName: Option[String] = None,
  storageos: Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] = None,
  volumeMode: Option[String] = None,
  vsphereVolume: Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None
)

object PersistentVolumeSpec {
  implicit lazy val encoder: Encoder.AsObject[PersistentVolumeSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PersistentVolumeSpec] = deriveDecoder
}
