package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a Photon Controller persistent disk resource.
 *
 *  @param   pdID  pdID is the ID that identifies Photon Controller persistent disk
 *  @param fsType  fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system.
 *                 Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
*/
case class PhotonPersistentDiskVolumeSource(
  pdID: String,
  fsType: Option[String] = None
)

object PhotonPersistentDiskVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[PhotonPersistentDiskVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[PhotonPersistentDiskVolumeSource] = deriveDecoder
}
