package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodCondition contains details for the current condition of this pod.
 *
 *  @param             `type`  Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
 *  @param             status  Status is the status of the condition. Can be True, False, Unknown. More info:
 *                             https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
 *  @param      lastProbeTime  Last time we probed the condition.
 *  @param lastTransitionTime  Last time the condition transitioned from one status to another.
 *  @param            message  Human-readable message indicating details about last transition.
 *  @param             reason  Unique, one-word, CamelCase reason for the condition's last transition.
*/
case class PodCondition(
  `type`: String,
  status: String,
  lastProbeTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  lastTransitionTime: Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message: Option[String] = None,
  reason: Option[String] = None
)

object PodCondition {
  implicit lazy val encoder: Encoder.AsObject[PodCondition] = deriveEncoder
  implicit lazy val decoder: Decoder[PodCondition] = deriveDecoder
}
