package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodDNSConfigOption defines DNS resolver options of a pod.
 *
 *  @param  name  Required.
 *  @param value
*/
case class PodDNSConfigOption(
  name: Option[String] = None,
  value: Option[String] = None
)

object PodDNSConfigOption {
  implicit lazy val encoder: Encoder.AsObject[PodDNSConfigOption] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDNSConfigOption] = deriveDecoder
}
