package io.k8s.api.policy.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodDisruptionBudgetSpec is a description of a PodDisruptionBudget.
 *
 *  @param maxUnavailable  An eviction is allowed if at most "maxUnavailable" pods selected by "selector" are unavailable after
 *                         the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary
 *                         evictions by specifying 0. This is a mutually exclusive setting with "minAvailable".
 *  @param   minAvailable  An eviction is allowed if at least "minAvailable" pods selected by "selector" will still be available
 *                         after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent
 *                         all voluntary evictions by specifying "100%".
 *  @param       selector  Label query over pods whose evictions are managed by the disruption budget. A null selector will
 *                         match no pods, while an empty ({}) selector will select all pods within the namespace.
*/
case class PodDisruptionBudgetSpec(
  maxUnavailable: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  minAvailable: Option[com.goyeau.kubernetes.client.IntOrString] = None,
  selector: Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
)

object PodDisruptionBudgetSpec {
  implicit lazy val encoder: Encoder.AsObject[PodDisruptionBudgetSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodDisruptionBudgetSpec] = deriveDecoder
}
