package io.k8s.api.batch.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodFailurePolicy describes how failed pods influence the backoffLimit.
 *
 *  @param rules  A list of pod failure policy rules. The rules are evaluated in order. Once a rule matches a Pod failure,
 *                the remaining of the rules are ignored. When no rule matches the Pod failure, the default handling applies
 *                - the counter of pod failures is incremented and it is checked against the backoffLimit. At most 20 elements
 *                are allowed.
*/
case class PodFailurePolicy(
  rules: Seq[io.k8s.api.batch.v1.PodFailurePolicyRule]
)

object PodFailurePolicy {
  implicit lazy val encoder: Encoder.AsObject[PodFailurePolicy] = deriveEncoder
  implicit lazy val decoder: Decoder[PodFailurePolicy] = deriveDecoder
}
