package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodReadinessGate contains the reference to a pod condition
 *
 *  @param conditionType  ConditionType refers to a condition in the pod's condition list with matching type.
*/
case class PodReadinessGate(
  conditionType: String
)

object PodReadinessGate {
  implicit lazy val encoder: Encoder.AsObject[PodReadinessGate] = deriveEncoder
  implicit lazy val decoder: Decoder[PodReadinessGate] = deriveDecoder
}
