package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodSpec is a description of a pod.
 *
 *  @param                    containers  List of containers belonging to the pod. Containers cannot currently be added or
 *                                        removed. There must be at least one container in a Pod. Cannot be updated.
 *  @param         activeDeadlineSeconds  Optional duration in seconds the pod may be active on the node relative to StartTime
 *                                        before the system will actively try to mark it failed and kill associated containers.
 *                                        Value must be a positive integer.
 *  @param                      affinity  If specified, the pod's scheduling constraints
 *  @param  automountServiceAccountToken  AutomountServiceAccountToken indicates whether a service account token should be
 *                                        automatically mounted.
 *  @param                     dnsConfig  Specifies the DNS parameters of a pod. Parameters specified here will be merged to
 *                                        the generated DNS configuration based on DNSPolicy.
 *  @param                     dnsPolicy  Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are 'ClusterFirstWithHostNet',
 *                                        'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged
 *                                        with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork,
 *                                        you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.
 *  @param            enableServiceLinks  EnableServiceLinks indicates whether information about services should be injected
 *                                        into pod's environment variables, matching the syntax of Docker links. Optional: Defaults
 *                                        to true.
 *  @param           ephemeralContainers  List of ephemeral containers run in this pod. Ephemeral containers may be run in
 *                                        an existing pod to perform user-initiated actions such as debugging. This list cannot
 *                                        be specified when creating a pod, and it cannot be modified by updating the pod spec.
 *                                        In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers
 *                                        subresource.
 *  @param                   hostAliases  HostAliases is an optional list of hosts and IPs that will be injected into the pod's
 *                                        hosts file if specified. This is only valid for non-hostNetwork pods.
 *  @param                       hostIPC  Use the host's ipc namespace. Optional: Default to false.
 *  @param                   hostNetwork  Host networking requested for this pod. Use the host's network namespace. If this
 *                                        option is set, the ports that will be used must be specified. Default to false.
 *  @param                       hostPID  Use the host's pid namespace. Optional: Default to false.
 *  @param                     hostUsers  Use the host's user namespace. Optional: Default to true. If set to true or not present,
 *                                        the pod will be run in the host user namespace, useful for when the pod needs a feature
 *                                        only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE.
 *                                        When set to false, a new userns is created for the pod. Setting false is useful for
 *                                        mitigating container breakout vulnerabilities even allowing users to run their containers
 *                                        as root without actually having root privileges on the host. This field is alpha-level
 *                                        and is only honored by servers that enable the UserNamespacesSupport feature.
 *  @param                      hostname  Specifies the hostname of the Pod If not specified, the pod's hostname will be set
 *                                        to a system-defined value.
 *  @param              imagePullSecrets  ImagePullSecrets is an optional list of references to secrets in the same namespace
 *                                        to use for pulling any of the images used by this PodSpec. If specified, these secrets
 *                                        will be passed to individual puller implementations for them to use. More info:
 *                                        https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
 *  @param                initContainers  List of initialization containers belonging to the pod. Init containers are executed
 *                                        in order prior to containers being started. If any init container fails, the pod is
 *                                        considered to have failed and is handled according to its restartPolicy. The name
 *                                        for an init container or normal container must be unique among all containers. Init
 *                                        containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup
 *                                        probes. The resourceRequirements of an init container are taken into account during
 *                                        scheduling by finding the highest request/limit for each resource type, and then using
 *                                        the max of of that value or the sum of the normal containers. Limits are applied to
 *                                        init containers in a similar fashion. Init containers cannot currently be added or
 *                                        removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
 *  @param                      nodeName  NodeName is a request to schedule this pod onto a specific node. If it is non-empty,
 *                                        the scheduler simply schedules this pod onto that node, assuming that it fits resource
 *                                        requirements.
 *  @param                  nodeSelector  NodeSelector is a selector which must be true for the pod to fit on a node. Selector
 *                                        which must match a node's labels for the pod to be scheduled on that node. More info:
 *                                        https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
 *  @param                            os  Specifies the OS of the containers in the pod. Some pod and container fields are
 *                                        restricted if this is set.
 *                                        If the OS field is set to linux, the following fields must be unset:
 *                                        -securityContext.windowsOptions
 *                                        If the OS field is set to windows, following fields must be unset: - spec.hostPID
 *                                        - spec.hostIPC - spec.hostUsers - spec.securityContext.seLinuxOptions - spec.securityContext.seccompProfile
 *                                        - spec.securityContext.fsGroup - spec.securityContext.fsGroupChangePolicy - spec.securityContext.sysctls
 *                                        - spec.shareProcessNamespace - spec.securityContext.runAsUser - spec.securityContext.runAsGroup
 *                                        - spec.securityContext.supplementalGroups - spec.containers[*].securityContext.seLinuxOptions
 *                                        - spec.containers[*].securityContext.seccompProfile - spec.containers[*].securityContext.capabilities
 *                                        - spec.containers[*].securityContext.readOnlyRootFilesystem - spec.containers[*].securityContext.privileged
 *                                        - spec.containers[*].securityContext.allowPrivilegeEscalation - spec.containers[*].securityContext.procMount
 *                                        - spec.containers[*].securityContext.runAsUser - spec.containers[*].securityContext.runAsGroup
 *  @param                      overhead  Overhead represents the resource overhead associated with running a pod for a given
 *                                        RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass
 *                                        admission controller. If the RuntimeClass admission controller is enabled, overhead
 *                                        must not be set in Pod create requests. The RuntimeClass admission controller will
 *                                        reject Pod create requests which have the overhead already set. If RuntimeClass is
 *                                        configured and selected in the PodSpec, Overhead will be set to the value defined
 *                                        in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero.
 *                                        More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md
 *  @param              preemptionPolicy  PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never,
 *                                        PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.
 *  @param                      priority  The priority value. Various system components use this field to find the priority
 *                                        of the pod. When Priority Admission Controller is enabled, it prevents users from
 *                                        setting this field. The admission controller populates this field from PriorityClassName.
 *                                        The higher the value, the higher the priority.
 *  @param             priorityClassName  If specified, indicates the pod's priority. "system-node-critical" and "system-cluster-critical"
 *                                        are two special keywords which indicate the highest priorities with the former being
 *                                        the highest priority. Any other name must be defined by creating a PriorityClass object
 *                                        with that name. If not specified, the pod priority will be default or zero if there
 *                                        is no default.
 *  @param                readinessGates  If specified, all readiness gates will be evaluated for pod readiness. A pod is ready
 *                                        when all its containers are ready AND all conditions specified in the readiness gates
 *                                        have status equal to "True" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates
 *  @param                 restartPolicy  Restart policy for all containers within the pod. One of Always, OnFailure, Never.
 *                                        Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
 *  @param              runtimeClassName  RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which
 *                                        should be used to run this pod.  If no RuntimeClass resource matches the named class,
 *                                        the pod will not be run. If unset or empty, the "legacy" RuntimeClass will be used,
 *                                        which is an implicit class with an empty definition that uses the default runtime
 *                                        handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
 *  @param                 schedulerName  If specified, the pod will be dispatched by specified scheduler. If not specified,
 *                                        the pod will be dispatched by default scheduler.
 *  @param               securityContext  SecurityContext holds pod-level security attributes and common container settings.
 *                                        Optional: Defaults to empty.  See type description for default values of each field
 *  @param                serviceAccount  DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated:
 *                                        Use serviceAccountName instead.
 *  @param            serviceAccountName  ServiceAccountName is the name of the ServiceAccount to use to run this pod. More
 *                                        info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
 *  @param             setHostnameAsFQDN  If true the pod's hostname will be configured as the pod's FQDN, rather than the
 *                                        leaf name (the default). In Linux containers, this means setting the FQDN in the hostname
 *                                        field of the kernel (the nodename field of struct utsname). In Windows containers,
 *                                        this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters
 *                                        to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
 *  @param         shareProcessNamespace  Share a single process namespace between all of the containers in a pod. When this
 *                                        is set containers will be able to view and signal processes from other containers
 *                                        in the same pod, and the first process in each container will not be assigned PID
 *                                        1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false
 *  @param                     subdomain  If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod
 *                                        namespace>.svc.<cluster domain>". If not specified, the pod will not have a domainname
 *                                        at all.
 *  @param terminationGracePeriodSeconds  Optional duration in seconds the pod needs to terminate gracefully. May be decreased
 *                                        in delete request. Value must be non-negative integer. The value zero indicates stop
 *                                        immediately via the kill signal (no opportunity to shut down). If this value is nil,
 *                                        the default grace period will be used instead. The grace period is the duration in
 *                                        seconds after the processes running in the pod are sent a termination signal and the
 *                                        time when the processes are forcibly halted with a kill signal. Set this value longer
 *                                        than the expected cleanup time for your process. Defaults to 30 seconds.
 *  @param                   tolerations  If specified, the pod's tolerations.
 *  @param     topologySpreadConstraints  TopologySpreadConstraints describes how a group of pods ought to spread across topology
 *                                        domains. Scheduler will schedule pods in a way which abides by the constraints. All
 *                                        topologySpreadConstraints are ANDed.
 *  @param                       volumes  List of volumes that can be mounted by containers belonging to the pod. More info:
 *                                        https://kubernetes.io/docs/concepts/storage/volumes
*/
case class PodSpec(
  containers: Seq[io.k8s.api.core.v1.Container],
  activeDeadlineSeconds: Option[Long] = None,
  affinity: Option[io.k8s.api.core.v1.Affinity] = None,
  automountServiceAccountToken: Option[Boolean] = None,
  dnsConfig: Option[io.k8s.api.core.v1.PodDNSConfig] = None,
  dnsPolicy: Option[String] = None,
  enableServiceLinks: Option[Boolean] = None,
  ephemeralContainers: Option[Seq[io.k8s.api.core.v1.EphemeralContainer]] = None,
  hostAliases: Option[Seq[io.k8s.api.core.v1.HostAlias]] = None,
  hostIPC: Option[Boolean] = None,
  hostNetwork: Option[Boolean] = None,
  hostPID: Option[Boolean] = None,
  hostUsers: Option[Boolean] = None,
  hostname: Option[String] = None,
  imagePullSecrets: Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  initContainers: Option[Seq[io.k8s.api.core.v1.Container]] = None,
  nodeName: Option[String] = None,
  nodeSelector: Option[Map[String, String]] = None,
  os: Option[io.k8s.api.core.v1.PodOS] = None,
  overhead: Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  preemptionPolicy: Option[String] = None,
  priority: Option[Int] = None,
  priorityClassName: Option[String] = None,
  readinessGates: Option[Seq[io.k8s.api.core.v1.PodReadinessGate]] = None,
  restartPolicy: Option[String] = None,
  runtimeClassName: Option[String] = None,
  schedulerName: Option[String] = None,
  securityContext: Option[io.k8s.api.core.v1.PodSecurityContext] = None,
  serviceAccount: Option[String] = None,
  serviceAccountName: Option[String] = None,
  setHostnameAsFQDN: Option[Boolean] = None,
  shareProcessNamespace: Option[Boolean] = None,
  subdomain: Option[String] = None,
  terminationGracePeriodSeconds: Option[Long] = None,
  tolerations: Option[Seq[io.k8s.api.core.v1.Toleration]] = None,
  topologySpreadConstraints: Option[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]] = None,
  volumes: Option[Seq[io.k8s.api.core.v1.Volume]] = None
)

object PodSpec {
  implicit lazy val encoder: Encoder.AsObject[PodSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodSpec] = deriveDecoder
}
