package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** PodTemplateSpec describes the data a pod should have when created from a template
 *
 *  @param metadata  Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param     spec  Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class PodTemplateSpec(
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.core.v1.PodSpec] = None
)

object PodTemplateSpec {
  implicit lazy val encoder: Encoder.AsObject[PodTemplateSpec] = deriveEncoder
  implicit lazy val decoder: Decoder[PodTemplateSpec] = deriveDecoder
}
