package io.k8s.api.core.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** Represents a projected volume source
 *
 *  @param defaultMode  defaultMode are the mode bits used to set permissions on created files by default. Must be an octal
 *                      value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal
 *                      values, JSON requires decimal values for mode bits. Directories within the path are not affected by
 *                      this setting. This might be in conflict with other options that affect the file mode, like fsGroup,
 *                      and the result can be other mode bits set.
 *  @param     sources  sources is the list of volume projections
*/
case class ProjectedVolumeSource(
  defaultMode: Option[Int] = None,
  sources: Option[Seq[io.k8s.api.core.v1.VolumeProjection]] = None
)

object ProjectedVolumeSource {
  implicit lazy val encoder: Encoder.AsObject[ProjectedVolumeSource] = deriveEncoder
  implicit lazy val decoder: Decoder[ProjectedVolumeSource] = deriveDecoder
}
