package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicaSet ensures that a specified number of pod replicas are running at any given time.
 *
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet
 *                     manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
 *  @param       spec  Spec defines the specification of the desired behavior of the ReplicaSet. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
 *  @param     status  Status is the most recently observed status of the ReplicaSet. This data may be out of date by some
 *                     window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
*/
case class ReplicaSet(
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec: Option[io.k8s.api.apps.v1.ReplicaSetSpec] = None,
  status: Option[io.k8s.api.apps.v1.ReplicaSetStatus] = None
)

object ReplicaSet {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSet] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSet] = deriveDecoder
}
