package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicaSetList is a collection of ReplicaSets.
 *
 *  @param      items  List of ReplicaSets. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
 *  @param apiVersion  APIVersion defines the versioned schema of this representation of an object. Servers should convert
 *                     recognized schemas to the latest internal value, and may reject unrecognized values. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
 *  @param       kind  Kind is a string value representing the REST resource this object represents. Servers may infer this
 *                     from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info:
 *                     https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
 *  @param   metadata  Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
*/
case class ReplicaSetList(
  items: Seq[io.k8s.api.apps.v1.ReplicaSet],
  apiVersion: Option[String] = None,
  kind: Option[String] = None,
  metadata: Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
)

object ReplicaSetList {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetList] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetList] = deriveDecoder
}
