package io.k8s.api.apps.v1

import io.circe.*
import io.circe.generic.semiauto.*

/** ReplicaSetStatus represents the current status of a ReplicaSet.
 *
 *  @param             replicas  Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller/#what-is-a-replicationcontroller
 *  @param    availableReplicas  The number of available replicas (ready for at least minReadySeconds) for this replica set.
 *  @param           conditions  Represents the latest available observations of a replica set's current state.
 *  @param fullyLabeledReplicas  The number of pods that have labels matching the labels of the pod template of the replicaset
 *  @param   observedGeneration  ObservedGeneration reflects the generation of the most recently observed ReplicaSet.
 *  @param        readyReplicas  readyReplicas is the number of pods targeted by this ReplicaSet with a Ready Condition.
*/
case class ReplicaSetStatus(
  replicas: Int,
  availableReplicas: Option[Int] = None,
  conditions: Option[Seq[io.k8s.api.apps.v1.ReplicaSetCondition]] = None,
  fullyLabeledReplicas: Option[Int] = None,
  observedGeneration: Option[Long] = None,
  readyReplicas: Option[Int] = None
)

object ReplicaSetStatus {
  implicit lazy val encoder: Encoder.AsObject[ReplicaSetStatus] = deriveEncoder
  implicit lazy val decoder: Decoder[ReplicaSetStatus] = deriveDecoder
}
